<?php

namespace App\Commands;

use CodeIgniter\CLI\BaseCommand;
use CodeIgniter\CLI\CLI;
use App\Services\AITextGeneratorService;

class TestAI extends BaseCommand
{
    protected $group       = 'Test';
    protected $name        = 'test:ai';
    protected $description = 'Test AI Generator functionality';

    public function run(array $params)
    {
        CLI::write('🤖 Testing AI Generator - Text Expansion', 'green');
        CLI::newLine();

        $aiService = new AITextGeneratorService();

        // Test 1: Expand "ringkas"
        CLI::write('Test 1: Expanding "ringkas"', 'yellow');
        CLI::write('Input: ringkas');
        $result1 = $aiService->expandText('ringkas', 'general');
        CLI::write('Success: ' . ($result1['success'] ? 'YES' : 'NO'));
        CLI::write('Output: ' . ($result1['text'] ?? 'No text'));
        CLI::newLine();

        // Test 2: Expand "pembelajaran"
        CLI::write('Test 2: Expanding "pembelajaran"', 'yellow');
        CLI::write('Input: pembelajaran');
        $result2 = $aiService->expandText('pembelajaran', 'pelatihan');
        CLI::write('Success: ' . ($result2['success'] ? 'YES' : 'NO'));
        CLI::write('Output: ' . ($result2['text'] ?? 'No text'));
        CLI::newLine();

        // Test 3: Expand "proyek web"
        CLI::write('Test 3: Expanding "proyek web"', 'yellow');
        CLI::write('Input: proyek web');
        $result3 = $aiService->expandText('proyek web', 'proyek');
        CLI::write('Success: ' . ($result3['success'] ? 'YES' : 'NO'));
        CLI::write('Output: ' . ($result3['text'] ?? 'No text'));
        CLI::newLine();

        CLI::write('✅ Test completed!', 'green');
    }
}